﻿using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using Telerik.Web.UI;
using System;

public class Reports
{

    #region Private Decs
    //stored proc const
    private const string GET_VISNS = "tbi.usp_Get_VISNs";
    private const string GET_TBI_CONNECTION_ERROR = "dbo.usp_GetTBIWarningErrorDetails";
    private const string GET_FACS = "tbi.usp_Get_Facs";
    private const string GET_FISCAL_YEARS = "tbi.usp_GetCalendarFiscalYears";
    private const string GET_PATIENT_SSN = "tbi.usp_getPatientSSNByDFNid";
    private string _userId;
    private DataTable _dtFac = null;

    #endregion

    public Reports(string userId)
	{
        _userId = userId;
	}

    /// <summary>
    /// Static value protected by access routine.
    /// </summary>
    static int _AllDivisionNodeCount;

    /// <summary>
    /// Access routine for global variable.
    /// </summary>
    public int AllDivisionNodeCount
    {
        get
        {
            return _AllDivisionNodeCount;
        }
        set
        {
            _AllDivisionNodeCount = value;
        }
    }

    #region Public DataTable Methods
    //***Populate Listboxes***//
    public DataTable GetVISNs()
    {
        return SqlProvider.ExecuteSPDataTable(Globals.GetConnectionName, GET_VISNS, new object[] { }); 
    }

    public DataTable GetFacs()
    {
        return SqlProvider.ExecuteSPDataTable(Globals.GetConnectionName, GET_FACS, new object[] { });
    }

    public DataTable GetFiscalYears()
    {
        return SqlProvider.ExecuteSPDataTable(Globals.GetConnectionName, GET_FISCAL_YEARS, new object[] { });
    }

    public DataTable GetTBIPatientSSN( string _DFN)
    {
        return SqlProvider.ExecuteSPDataTable(Globals.GetConnectionName, GET_PATIENT_SSN, new object[] { _DFN });
    }

    public DataTable GetTBIConnectionError()
    {
        return SqlProvider.ExecuteSPDataTable(Globals.GetConnectionName, GET_TBI_CONNECTION_ERROR, new object[] { _userId });
    }
    #endregion

    #region Public String Arrays Methods
    //*************************************************/
    //Gets string array of survey types
    public string[] GetStringArrayFromRadListForSurvey(RadListBox rlb)
    {
        string[] _array;
        int _counter = 0;

        if (rlb.CheckedItems.Count > 0)
        {
            _array = new string[rlb.CheckedItems.Count];

            foreach (RadListBoxItem item in rlb.CheckedItems)
            {
                if (item.Checked)
                {
                    if (item.Value != DBNull.Value.ToString())
                    {
                        if (item.Value != "All" && item.Value != "null")
                        {
                            _array[_counter] = item.Value;
                            _counter++;
                        }
                    }
                }
            }
        }
        else
        {
            _array = new string[_counter];
        }

        return _array;
    }

    public string[] GetArrayListFromRadTreeView(RadTreeView rtv, string type, string[] _visns)
    {
        string[] _array;
        int _counter = 0;

        if (rtv.CheckedNodes.Count > 0)
        {
            //if ( rtv.CheckedNodes.Count == 1 )
            //    _array = new string[rtv.CheckedNodes.Count - 1];
            //else
            //    _array = new string[rtv.CheckedNodes.Count];
            _array = new string[_AllDivisionNodeCount - 1];
            if (type == "VISNS")
            {
                #region "VISNS"
                if (rtv.Nodes[0].Checked == true)//All Option checked
                {
                    _array = new string[_AllDivisionNodeCount - 1];
                    foreach (RadTreeNode visnNode in rtv.Nodes)//ds.Tables[0].Rows
                    {
                        foreach (RadTreeNode facNode in visnNode.Nodes)
                        {
                            if (facNode.Text != "All" && facNode.Text != "null")
                            {
                                _array[ _counter] = facNode.Text;
                                _counter++;
                            }
                        }
                    }
                }
                else
                {
                    foreach (RadTreeNode visnNode in rtv.Nodes)//ds.Tables[0].Rows
                    {
                        foreach (RadTreeNode facNode in visnNode.Nodes)
                        {
                            if (facNode.Checked)
                            {
                                if (facNode.Text != "All" && facNode.Text != "null")
                                {
                                    _array[_counter] = facNode.Text;
                                    _counter++;
                                }
                            }
                        }
                    }
                }
            #endregion
            }
            else if (type == "FACILITIES")
            {
                #region "Facs/Stations"

                if (rtv.Nodes[0].Checked == true)//All Option checked
                {
                    _array = new string[_AllDivisionNodeCount - 1];
                    foreach (RadTreeNode visnNode in rtv.Nodes)
                    {
                        foreach (RadTreeNode facNode in visnNode.Nodes)
                        {
                            foreach (RadTreeNode facilityNode in facNode.Nodes)
                            {
                                _array[_counter] = facilityNode.Text;
                                _counter++;
                            }
                        }
                    }
                }
                else
                {
                    foreach (RadTreeNode visnNode in rtv.Nodes)
                    {
                        foreach (RadTreeNode facNode in visnNode.Nodes)
                        {
                            foreach (RadTreeNode facilityNode in facNode.Nodes)
                            {
                                if (facilityNode.Checked)
                                {
                                    _array[_counter] = facilityNode.Text;
                                    _counter++;
                                }
                            }
                        }
                    }
                }
                #endregion
            }
            else if (type == "STATIONNUMBERS")
            {
                #region "STATION NUMBERS"

                if (rtv.Nodes[0].Checked == true)//All Option checked
                {
                    _array = new string[_AllDivisionNodeCount - 1];
                    foreach (RadTreeNode visnNode in rtv.Nodes)
                    {
                        foreach (RadTreeNode facNode in visnNode.Nodes)
                        {
                            foreach (RadTreeNode facilityNode in facNode.Nodes)
                            {
                                _array[ _counter] = facilityNode.Value;
                                _counter++;
                            }
                        }
                    }
                }
                else
                {
                    foreach (RadTreeNode visnNode in rtv.Nodes)
                    {
                        foreach (RadTreeNode facNode in visnNode.Nodes)
                        {
                            foreach (RadTreeNode facilityNode in facNode.Nodes)
                            {
                                if (facilityNode.Checked)
                                {
                                    _array[_counter] = facilityNode.Value;
                                    _counter++;
                                }
                            }
                        }
                    }
                }
                #endregion
            }
            else if (type == "UNCHECKED_FACS")
            {
                #region "Visns Selected only Facility Values"
                _counter = 0;

                _array = new string[_AllDivisionNodeCount - 1];
                foreach (string _strvisn in _visns)
                {
                    if (_strvisn != null)
                    {
                        foreach (RadTreeNode visnNode in rtv.Nodes)
                        {
                            foreach (RadTreeNode facNode in visnNode.Nodes)
                            {
                                if (facNode != null)
                                {
                                    if (facNode.Text == _strvisn)
                                    {
                                        foreach (RadTreeNode facilityNode in facNode.Nodes)
                                        {
                                            _array[_counter] = facilityNode.Text;
                                            _counter++;
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
               
                #endregion
            }

            else if (type == "UNCHECKED_STATIONS")
            {
                #region "Visns Selected only Stations Values"
                _counter = 0;

                _array = new string[_AllDivisionNodeCount - 1];
                foreach (string _strvisn in _visns)
                {
                    if (_strvisn != null)
                    {
                        foreach (RadTreeNode visnNode in rtv.Nodes)
                        {
                            foreach (RadTreeNode facNode in visnNode.Nodes)
                            {
                                if (facNode != null)
                                {
                                    if (facNode.Text == _strvisn)
                                    {
                                        foreach (RadTreeNode facilityNode in facNode.Nodes)
                                        {
                                            _array[_counter] = facilityNode.Value;
                                            _counter++;
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
               
                #endregion
            }
        }
        else
        {
            _array = new string[0];
        }

        return _array;
    }
    #endregion
}
